#open "syntaxe";;
#open "eval";;
#open "types";;
#open "synthese";;

(* L'environnement d'valuation *)

let code_nombre n =
    Val_nombre n
and dcode_nombre = function
  | Val_nombre n -> n
  | _ -> raise(Erreur "entier attendu")
and code_boolen b =
    Val_boolenne b
and dcode_boolen = function
  | Val_boolenne b -> b
  | _ -> raise(Erreur "boolen attendu");;

(* Pour transformer une fonction Caml en valeur fonctionnelle *)

let prim1 codeur calcul dcodeur =
  Val_primitive(function val -> codeur (calcul (dcodeur val)))
and prim2 codeur calcul dcodeur1 dcodeur2 =
  Val_primitive(function
   | Val_paire (v1, v2) ->
      codeur (calcul (dcodeur1 v1) (dcodeur2 v2))
   | _ -> raise (Erreur "paire attendue"));;

(* L'environnement initial *)

let env_val_initial =
  ["+",  prim2 code_nombre  (prefix + ) dcode_nombre dcode_nombre;
   "-",  prim2 code_nombre  (prefix - ) dcode_nombre dcode_nombre;
   "*",  prim2 code_nombre  (prefix * ) dcode_nombre dcode_nombre;
   "/",  prim2 code_nombre  (prefix / ) dcode_nombre dcode_nombre;
   "=",  prim2 code_boolen (prefix = ) dcode_nombre dcode_nombre;
   "<>", prim2 code_boolen (prefix <>) dcode_nombre dcode_nombre;
   "<",  prim2 code_boolen (prefix < ) dcode_nombre dcode_nombre;
   ">",  prim2 code_boolen (prefix > ) dcode_nombre dcode_nombre;
   "<=", prim2 code_boolen (prefix <=) dcode_nombre dcode_nombre;
   ">=", prim2 code_boolen (prefix >=) dcode_nombre dcode_nombre;
   "not", prim1 code_boolen (prefix not) dcode_boolen;
   "read_int", prim1 code_nombre (fun x -> read_int()) dcode_nombre;
   "write_int", prim1 code_nombre
                      (fun x -> print_int x; print_newline(); 0)
                      dcode_nombre];;

(* L'environnement de typage *)

let type_arithmtique = schma_trivial
  (type_flche (type_produit type_int type_int) type_int)
and type_comparaison =  schma_trivial
  (type_flche (type_produit type_int type_int) type_bool);;

let env_typage_initial =
  ["+",  type_arithmtique;     "-",  type_arithmtique;
   "*",  type_arithmtique;     "/",  type_arithmtique;
   "=",  type_comparaison;      "<>", type_comparaison;
   "<",  type_comparaison;      ">",  type_comparaison;
   "<=", type_comparaison;      ">=", type_comparaison;
   "not", schma_trivial(type_flche type_bool type_bool);
   "read_int", schma_trivial(type_flche type_int type_int);
   "write_int", schma_trivial(type_flche type_int type_int)];;

(* La boucle principale *)

let boucle () =
  let env_typage = ref env_typage_initial
  and env_val = ref env_val_initial in
  let flux_d'entre = stream_of_channel std_in in
  while true do
    print_string "# "; flush std_out;
    try
      match lire_phrase flux_d'entre with
      | Expression expr ->
          let ty = type_exp !env_typage expr in
          let rs = value !env_val expr in
          print_string "- : "; imprime_type ty;
          print_string " = "; imprime_valeur rs;
          print_newline()
      | Dfinition df ->
          let nouvel_env_typage = type_df !env_typage df in
          let nouvel_env_val = value_dfinition !env_val df in
          begin match (nouvel_env_typage, nouvel_env_val) with
          | (nom, schma) :: _, (_, val) :: _ ->
              print_string nom; print_string " : ";
              imprime_schma schma;
              print_string " = "; imprime_valeur val;
              print_newline()
          | _ -> failwith "incorrect traitement des dfinitions"
          end;
          env_typage := nouvel_env_typage;
          env_val := nouvel_env_val
    with
      Parse_error | Parse_failure ->
        print_string "Erreur de syntaxe"; print_newline()
    | Conflit(ty1, ty2) ->
        print_string "Incompatibilit de types entre ";
        imprime_type ty1; print_string " et ";
        imprime_type ty2; print_newline()
    | Circularit(var, ty) ->
        print_string "Impossible d'identifier ";
        imprime_type var; print_string " et ";
        imprime_type ty; print_newline()
    | eval__Erreur msg ->
        print_string "Erreur  l'valuation: "; print_string msg;
        print_newline()
    | synthese__Erreur msg ->
        print_string "Erreur de typage: "; print_string msg;
        print_newline()
  done;;

if sys__interactive then () else boucle();;
